<?php
echo $this->Form->create('User', array(
    'inputDefaults' => array(
        'label' => false,
        'div'   => false,
        'class' => 'form-control placeholder-no-fix',
        'error' => array(
            'attributes' => array( 'wrap' => 'span', 'class' => 'help-block' )
        ),
    //'autocomplete' => 'off'
    )
));
?>
<h3>Add a New User Account</h3>

<div class="form-group <?php echo($this->Form->isFieldError('plan_id') ? 'has-error' : ''); ?>">
    <label class="control-label" for="LinkBundleId">Plan</label>
    <?php
    echo $this->Form->input('plan_id', array(
        'options' => $plans,
        'empty'   => 'Select Plan'
    ));
    ?>
</div>

<div class="form-group <?php echo($this->Form->isFieldError('account_type') ? 'has-error' : ''); ?>">
    <label for="UserAccountType" class="control-label">Account Type</label>
    <?php
    echo $this->Form->input('account_type', array(
        'options' => array(
            'Free'  => 'Free',
            'Admin' => 'Admin'
        ),
        'empty'   => 'Account Type'
    ));
    ?>
</div>
<div class="form-group <?php echo($this->Form->isFieldError('status') ? 'has-error' : ''); ?>">
    <label for="UserStatus" class="control-label">Status</label>
    <?php
    echo $this->Form->input('status', array(
        'options' => array(
            'Active'   => 'Active',
            'Inactive' => 'Inactive',
            'Banned'   => 'Banned'
        ),
        'empty'   => 'Status'
    ));
    ?>
</div>

<div class="form-group <?php echo($this->Form->isFieldError('username') ? 'has-error' : ''); ?>">
    <label for="UserUsername" class="control-label">Username</label>
    <div class="input-group">
        <div class="input-group-addon"><i class="fa fa-user"></i></div>
        <?php
        echo $this->Form->input('username', array(
            'placeholder' => 'Username'
        ));
        ?>
    </div>
</div>

<div class="row">
    <div class="col-sm-6">
        <div class="form-group <?php echo($this->Form->isFieldError('password') ? 'has-error' : ''); ?>">
            <label for="UserPwd" class="control-label">Password</label>
            <div class="input-group">
                <div class="input-group-addon"><i class="fa fa-lock"></i></div>
                <?php
                echo $this->Form->input('password', array(
                    'type'        => 'password',
                    'placeholder' => 'Password'
                ));
                ?>
            </div>
        </div>
    </div>
    <div class="col-sm-6">
        <div class="form-group <?php echo($this->Form->isFieldError('confirm_password') ? 'has-error' : ''); ?>">
            <label for="UserConfirmPassword" class="control-label">Re-type Your Password</label>
            <div class="controls">
                <div class="input-group">
                    <div class="input-group-addon"><i class="fa fa-check"></i></div>
                    <?php
                    echo $this->Form->input('confirm_password', array(
                        'type'        => 'password',
                        'placeholder' => 'Re-type Your Password'
                    ));
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="form-group <?php echo($this->Form->isFieldError('email') ? 'has-error' : ''); ?>">
    <label for="UserEmail" class="control-label">Email</label>
    <div class="input-group">
        <div class="input-group-addon"><i class="fa fa-envelope"></i></div>
        <?php
        echo $this->Form->input('email', array( 'placeholder' => 'Email' ));
        ?>
    </div>
</div>



<div class="row">
    <div class="col-sm-6">
        <div class="form-group <?php echo($this->Form->isFieldError('first_name') ? 'has-error' : ''); ?>">
            <label for="UserFirstName" class="control-label">First Name</label>
            <div class="input-group">
                <div class="input-group-addon"><i class="fa fa-font"></i></div>
                <?php
                echo $this->Form->input('first_name', array( 'placeholder' => 'First Name' ));
                ?>
            </div>
        </div>
    </div>
    <div class="col-sm-6">
        <div class="form-group <?php echo($this->Form->isFieldError('last_name') ? 'has-error' : ''); ?>">
            <label for="UserLastName" class="control-label">Last Name</label>
            <div class="input-group">
                <div class="input-group-addon"><i class="fa fa-font"></i></div>
                <?php
                echo $this->Form->input('last_name', array( 'placeholder' => 'Last Name' ));
                ?>
            </div>
        </div>
    </div>
</div>

<div class="form-group <?php echo($this->Form->isFieldError('country') ? 'has-error' : ''); ?>">
    <label for="UserCountry" class="control-label">Country</label>
    <?php
    echo $this->Form->input('country', array(
        'options' => get_countries(),
        'empty'   => 'Choose Country'
    ));
    ?>
</div>

<div class="form-group <?php echo($this->Form->isFieldError('sharing') ? 'has-error' : ''); ?>">
    <div class="input-group">
        <?php
        echo $this->Form->input('sharing', array( 'label' => 'Share Buttons' ));
        ?>
    </div>
</div>

<div class="form-group <?php echo($this->Form->isFieldError('disqus_shortname') ? 'has-error' : ''); ?>">
    <label for="UserDisqusShortname" class="control-label">disqus_shortname</label>
    <div class="input-group">
        <div class="input-group-addon"><i class="fa fa-comments"></i></div>
        <?php
        echo $this->Form->input('disqus_shortname', array( 'placeholder' => 'disqus_shortname' ));
        ?>
    </div>
</div>


<div class="form-group <?php echo($this->Form->isFieldError('timer') ? 'has-error' : ''); ?>">
    <label for="UserTimer" class="control-label">Timer <small class="text-muted"><b>Working on "Custom Page" redirection type only</b></small></label>
    <div class="input-group">
        <div class="input-group-addon"><i class="fa fa-clock-o"></i></div>
        <?php
        echo $this->Form->input('timer', array( 'placeholder' => 'Timer' ));
        ?>
    </div>
</div>

<div class="form-actions">
    <?php
    echo $this->Form->end(array(
        'label' => 'Submit',
        'class' => 'btn btn-primary pull-right'
    ));
    ?>
</div>